% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program fittingROC1.m
function ROC = fittingROC1(Srating, Nrating)

freqHits(1) = Srating(6); 
freqFA(1) = Nrating(6);
for i = 2:6
    freqHits(i) = freqHits(i-1) + Srating(7-i);
    freqFA(i) = freqFA(i-1) + Nrating(7-i);
end
                
pHits = freqHits(1:5)/freqHits(6);
pFA = freqFA(1:5)/freqFA(6);
zHits = norminv(pHits);
zFA = norminv(pFA);
data = [zHits; zFA];

guess = [1 1.5 -2 -1 0 1 2];
options = optimset('fminsearch');
ROC = fminsearch('ROC1costfunc', guess, options, data);

% compute r2
zHits_observed =data(1,:);
zFA_observed = data(2, :);
d = ROC(1);
sigma = ROC(2);
criteria = ROC(3:7);
zHits_predicted = norminv(1-normcdf(criteria, d, sigma));
zFA_predicted  = norminv(1- normcdf(criteria, 0, 1));
mean_zHits = mean(zHits_observed);
mean_zPA = mean(zFA_observed);
r2 = 1- 0.5*sum((zHits_observed - zHits_predicted).^2) ...  
     /sum((zHits_observed-mean_zHits).^2) - ...
     0.5*sum((zFA_observed -zFA_predicted).^2) ...
     /sum((zFA_observed-mean_zPA).^2)

